/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.event;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SliderThumbDragHandler
extends PDragSequenceEventHandler {
    private final Orientation orientation;
    private final PNode relativeNode;
    private final PNode trackNode;
    private final PNode thumbNode;
    private final DoubleRange range;
    private final VoidFunction1<Double> updateFunction;
    private final Function.LinearFunction valueFunction;
    private double globalClickXOffset;
    private double globalClickYOffset;

    public SliderThumbDragHandler(Orientation orientation, PNode pNode, PNode pNode2, PNode pNode3, DoubleRange doubleRange, VoidFunction1<Double> voidFunction1) {
        this.orientation = orientation;
        this.relativeNode = pNode;
        this.trackNode = pNode2;
        this.thumbNode = pNode3;
        this.range = doubleRange;
        this.updateFunction = voidFunction1;
        this.valueFunction = orientation == Orientation.HORIZONTAL ? new Function.LinearFunction(0.0, pNode2.getFullBoundsReference().getWidth(), doubleRange.getMin(), doubleRange.getMax()) : new Function.LinearFunction(0.0, pNode2.getFullBoundsReference().getHeight(), doubleRange.getMax(), doubleRange.getMin());
    }

    @Override
    protected void startDrag(PInputEvent pInputEvent) {
        super.startDrag(pInputEvent);
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.relativeNode);
        Point2D point2D2 = this.relativeNode.localToGlobal(point2D);
        Point2D point2D3 = this.relativeNode.localToGlobal(this.thumbNode.getOffset());
        this.globalClickXOffset = point2D2.getX() - point2D3.getX() + this.trackNode.getXOffset();
        this.globalClickYOffset = point2D2.getY() - point2D3.getY() + this.trackNode.getYOffset();
    }

    @Override
    protected void drag(PInputEvent pInputEvent) {
        super.drag(pInputEvent);
        this.updateValue(pInputEvent, true);
    }

    @Override
    protected void endDrag(PInputEvent pInputEvent) {
        this.updateValue(pInputEvent, false);
        super.endDrag(pInputEvent);
    }

    protected double adjustValue(double d) {
        return d;
    }

    private void updateValue(PInputEvent pInputEvent, boolean bl) {
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.relativeNode);
        Point2D point2D2 = this.relativeNode.localToGlobal(point2D);
        Point2D.Double double_ = new Point2D.Double(point2D2.getX() - this.globalClickXOffset, point2D2.getY() - this.globalClickYOffset);
        Point2D point2D3 = this.relativeNode.globalToLocal(double_);
        double d = this.valueFunction.evaluate(this.orientation == Orientation.HORIZONTAL ? point2D3.getX() : point2D3.getY());
        d = MathUtil.clamp(d, this.range);
        if (!bl) {
            d = this.adjustValue(d);
        }
        this.updateFunction.apply(d);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Orientation
    extends Enum<Orientation> {
        public static final /* enum */ Orientation HORIZONTAL = new Orientation();
        public static final /* enum */ Orientation VERTICAL = new Orientation();
        private static final /* synthetic */ Orientation[] $VALUES;

        public static Orientation[] values() {
            return (Orientation[])$VALUES.clone();
        }

        static {
            $VALUES = new Orientation[]{HORIZONTAL, VERTICAL};
        }
    }
}

