/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.controls;

import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.simsharing.Parameter;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingEvents;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyCheckBox
extends JCheckBox {
    private final SettableProperty<Boolean> property;
    private final SimpleObserver propertyObserver;

    public PropertyCheckBox(String string, final SettableProperty<Boolean> settableProperty) {
        super(string);
        this.property = settableProperty;
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyCheckBox.notifyActionPerformed(PropertyCheckBox.this, settableProperty);
                settableProperty.set(PropertyCheckBox.this.isSelected());
            }
        });
        this.propertyObserver = new SimpleObserver(){

            public void update() {
                PropertyCheckBox.this.setSelected((Boolean)settableProperty.get());
            }
        };
        settableProperty.addObserver(this.propertyObserver);
    }

    public static void notifyActionPerformed(JCheckBox jCheckBox, SettableProperty<Boolean> settableProperty) {
        SimSharingEvents.sendEvent("checkBox", "pressed", Parameter.param("text", jCheckBox.getText()), Parameter.param("description", settableProperty.getDescriptionOrElseQuestion()), Parameter.param("isSelected", jCheckBox.isSelected()));
    }
}

