/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.view.meters;

import edu.colorado.phet.capacitorlab.CLImages;
import edu.colorado.phet.capacitorlab.drag.WorldLocationDragHandler;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.WorldLocationProperty;
import edu.colorado.phet.capacitorlab.model.meter.Voltmeter;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Image;
import java.awt.geom.Point2D;

abstract class VoltmeterProbeNode
extends PhetPNode {
    private final Point2D connectionOffset;

    public VoltmeterProbeNode(Image image, final WorldLocationProperty worldLocationProperty, final CLModelViewTransform3D cLModelViewTransform3D) {
        PImage pImage = new PImage(image);
        this.addChild(pImage);
        double d = -pImage.getFullBoundsReference().getWidth() / 2.0;
        double d2 = 0.0;
        pImage.setOffset(d, d2);
        this.connectionOffset = new Point2D.Double(0.0, pImage.getFullBoundsReference().getHeight());
        this.rotate(-cLModelViewTransform3D.getYaw());
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new WorldLocationDragHandler(worldLocationProperty, this, cLModelViewTransform3D));
        worldLocationProperty.addObserver(new SimpleObserver(){

            public void update() {
                VoltmeterProbeNode.this.setOffset(cLModelViewTransform3D.modelToView((Point3D)worldLocationProperty.get()));
            }
        });
    }

    public Point2D getConnectionOffset() {
        return new Point2D.Double(this.connectionOffset.getX(), this.connectionOffset.getY());
    }

    public static class NegativeVoltmeterProbeNode
    extends VoltmeterProbeNode {
        public NegativeVoltmeterProbeNode(Voltmeter voltmeter, CLModelViewTransform3D cLModelViewTransform3D) {
            super(CLImages.BLACK_VOLTMETER_PROBE, voltmeter.negativeProbeLocationProperty, cLModelViewTransform3D);
        }
    }

    public static class PositiveVoltmeterProbeNode
    extends VoltmeterProbeNode {
        public PositiveVoltmeterProbeNode(Voltmeter voltmeter, CLModelViewTransform3D cLModelViewTransform3D) {
            super(CLImages.RED_VOLTMETER_PROBE, voltmeter.positiveProbeLocationProperty, cLModelViewTransform3D);
        }
    }
}

