/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.view.meters;

import edu.colorado.phet.capacitorlab.CLImages;
import edu.colorado.phet.capacitorlab.CLStrings;
import edu.colorado.phet.capacitorlab.drag.WorldLocationDragHandler;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.meter.Voltmeter;
import edu.colorado.phet.capacitorlab.view.DoubleDisplayNode;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;

class VoltmeterBodyNode
extends PhetPNode {
    private static final Image BODY_IMAGE = CLImages.VOLTMETER;
    private static final NumberFormat DISPLAY_VALUE_FORMAT = new DefaultDecimalFormat("0.00");
    private static final Font DISPLAY_FONT = new PhetFont(16);
    private static final Color DISPLAY_TEXT_COLOR = Color.BLACK;
    private static final Color DISPLAY_BACKGROUND_COLOR = Color.WHITE;
    private final DoubleDisplayNode displayNode;
    private final PPath displayBackgroundNode;
    private final Point2D positiveConnectionOffset;
    private final Point2D negativeConnectionOffset;

    public VoltmeterBodyNode(final Voltmeter voltmeter, final CLModelViewTransform3D cLModelViewTransform3D) {
        PImage pImage = new PImage(BODY_IMAGE);
        this.addChild(pImage);
        PImage pImage2 = new PImage(CLImages.CLOSE_BUTTON);
        pImage2.addInputEventListener(new CursorHandler());
        pImage2.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseReleased(PInputEvent pInputEvent) {
                voltmeter.visibleProperty.set(false);
            }
        });
        this.addChild(pImage2);
        double d = pImage.getFullBoundsReference().getMaxX() + 2.0;
        double d2 = pImage.getFullBoundsReference().getMinY();
        pImage2.setOffset(d, d2);
        double d3 = 0.1 * pImage.getFullBoundsReference().getWidth();
        double d4 = 0.08 * pImage.getFullBoundsReference().getHeight();
        double d5 = pImage.getFullBoundsReference().getWidth() - 2.0 * d3;
        double d6 = 0.28 * pImage.getFullBoundsReference().getHeight() - 2.0 * d4;
        this.displayBackgroundNode = new PPath(new Rectangle2D.Double(d3, d4, d5, d6));
        this.displayBackgroundNode.setStroke(null);
        this.displayBackgroundNode.setPaint(DISPLAY_BACKGROUND_COLOR);
        this.addChild(this.displayBackgroundNode);
        this.displayNode = new DoubleDisplayNode(voltmeter.getValue(), "", DISPLAY_VALUE_FORMAT, CLStrings.VOLTS, CLStrings.PATTERN_LABEL_VALUE_UNITS, CLStrings.VOLTS_UNKNOWN);
        this.displayNode.setFont(DISPLAY_FONT);
        this.displayNode.setHTMLColor(DISPLAY_TEXT_COLOR);
        this.addChild(this.displayNode);
        PBounds pBounds = pImage.getFullBoundsReference();
        this.positiveConnectionOffset = new Point2D.Double(pBounds.getWidth() / 4.0, pBounds.getMaxY());
        this.negativeConnectionOffset = new Point2D.Double(3.0 * pBounds.getWidth() / 4.0, pBounds.getMaxY());
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new WorldLocationDragHandler(voltmeter.bodyLocationProperty, this, cLModelViewTransform3D));
        voltmeter.addValueObserver(new SimpleObserver(){

            public void update() {
                VoltmeterBodyNode.this.displayNode.setValue(voltmeter.getValue());
                VoltmeterBodyNode.this.updateLayout();
            }
        });
        voltmeter.bodyLocationProperty.addObserver(new SimpleObserver(){

            public void update() {
                VoltmeterBodyNode.this.setOffset(cLModelViewTransform3D.modelToView((Point3D)voltmeter.bodyLocationProperty.get()));
            }
        });
    }

    public Point2D getPositiveConnectionOffset() {
        return new Point2D.Double(this.positiveConnectionOffset.getX(), this.positiveConnectionOffset.getY());
    }

    public Point2D getNegativeConnectionOffset() {
        return new Point2D.Double(this.negativeConnectionOffset.getX(), this.negativeConnectionOffset.getY());
    }

    private void updateLayout() {
        double d = this.displayBackgroundNode.getFullBoundsReference().getMaxX() - this.displayNode.getFullBoundsReference().getWidth() - 4.0;
        double d2 = this.displayBackgroundNode.getFullBoundsReference().getMaxY() - this.displayNode.getFullBoundsReference().getHeight() - 1.0;
        this.displayNode.setOffset(d, d2);
    }
}

