/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.view.meters;

import edu.colorado.phet.capacitorlab.CLImages;
import edu.colorado.phet.capacitorlab.drag.WorldLocationDragHandler;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.meter.EFieldDetector;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

class EFieldDetectorProbeNode
extends PhetPNode {
    private final Point2D connectionOffset;

    public EFieldDetectorProbeNode(final EFieldDetector eFieldDetector, final CLModelViewTransform3D cLModelViewTransform3D, boolean bl) {
        PImage pImage = new PImage(CLImages.EFIELD_PROBE);
        this.addChild(pImage);
        double d = -pImage.getFullBoundsReference().getWidth() / 2.0;
        double d2 = -14.5;
        pImage.setOffset(d, d2);
        this.connectionOffset = new Point2D.Double(0.0, pImage.getFullBoundsReference().getHeight() + d2);
        this.rotate(-cLModelViewTransform3D.getYaw());
        if (bl) {
            double d3 = 4.0;
            PPath pPath = new PPath(new Ellipse2D.Double(-d3 / 2.0, -d3 / 2.0, d3, d3));
            pPath.setStroke(null);
            pPath.setPaint(Color.RED);
            this.addChild(pPath);
        }
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new WorldLocationDragHandler(eFieldDetector.probeLocationProperty, this, cLModelViewTransform3D));
        eFieldDetector.probeLocationProperty.addObserver(new SimpleObserver(){

            public void update() {
                EFieldDetectorProbeNode.this.setOffset(cLModelViewTransform3D.modelToView((Point3D)eFieldDetector.probeLocationProperty.get()));
            }
        });
    }

    public Point2D getConnectionOffset() {
        return new Point2D.Double(this.connectionOffset.getX(), this.connectionOffset.getY());
    }
}

