/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.view;

import edu.colorado.phet.capacitorlab.CLPaints;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.model.Polarity;
import edu.colorado.phet.capacitorlab.view.BoxNode;
import edu.colorado.phet.capacitorlab.view.PlateChargeNode;

public abstract class PlateNode
extends BoxNode {
    private final PlateChargeNode dielectricPlateChargeNode;
    private final PlateChargeNode airPlateChargeNode;

    public PlateNode(Capacitor capacitor, CLModelViewTransform3D cLModelViewTransform3D, Polarity polarity, double d, float f) {
        super(cLModelViewTransform3D, CLPaints.PLATE, capacitor.getPlateSize());
        this.dielectricPlateChargeNode = new PlateChargeNode.DielectricPlateChargeNode(capacitor, cLModelViewTransform3D, polarity, d, f);
        this.addChild(this.dielectricPlateChargeNode);
        this.airPlateChargeNode = new PlateChargeNode.AirPlateChargeNode(capacitor, cLModelViewTransform3D, polarity, d);
        this.addChild(this.airPlateChargeNode);
    }

    public void setChargeVisible(boolean bl) {
        this.dielectricPlateChargeNode.setVisible(bl);
        this.airPlateChargeNode.setVisible(bl);
    }

    public static class BottomPlateNode
    extends PlateNode {
        public BottomPlateNode(Capacitor capacitor, CLModelViewTransform3D cLModelViewTransform3D, double d) {
            super(capacitor, cLModelViewTransform3D, Polarity.NEGATIVE, d, 0.25f);
        }
    }

    public static class TopPlateNode
    extends PlateNode {
        public TopPlateNode(Capacitor capacitor, CLModelViewTransform3D cLModelViewTransform3D, double d) {
            super(capacitor, cLModelViewTransform3D, Polarity.POSITIVE, d, 1.0f);
        }
    }
}

