/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.view;

import edu.colorado.phet.capacitorlab.CLConstants;
import edu.colorado.phet.capacitorlab.CLStrings;
import edu.colorado.phet.capacitorlab.control.CapacitanceControlNode;
import edu.colorado.phet.capacitorlab.model.Battery;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.model.DielectricChargeView;
import edu.colorado.phet.capacitorlab.model.circuit.ICircuit;
import edu.colorado.phet.capacitorlab.model.wire.Wire;
import edu.colorado.phet.capacitorlab.view.BatteryNode;
import edu.colorado.phet.capacitorlab.view.CapacitorNode;
import edu.colorado.phet.capacitorlab.view.CurrentIndicatorNode;
import edu.colorado.phet.capacitorlab.view.WireNode;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.util.PNodeLayoutUtils;
import edu.umd.cs.piccolo.PNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleCapacitorsCircuitNode
extends PhetPNode {
    private final ICircuit circuit;

    /*
     * WARNING - void declaration
     */
    public MultipleCapacitorsCircuitNode(ICircuit iCircuit, CLModelViewTransform3D cLModelViewTransform3D, boolean bl, Property<Boolean> property, Property<Boolean> property2, Property<DielectricChargeView> property3, double d, double d2, double d3, double d4) {
        void var19_17;
        double d5;
        double d6;
        PNode pNode;
        PNode pNode2;
        this.circuit = iCircuit;
        Battery battery = iCircuit.getBattery();
        BatteryNode batteryNode = new BatteryNode(battery, CLConstants.BATTERY_VOLTAGE_RANGE);
        this.addChild(batteryNode);
        batteryNode.setOffset(cLModelViewTransform3D.modelToView(battery.getLocationReference()));
        int n = 1;
        for (Capacitor object2 : iCircuit.getCapacitors()) {
            pNode2 = new CapacitorNode(object2, cLModelViewTransform3D, bl, property, property2, property3, d, d2, d3, d4);
            ((CapacitorNode)pNode2).getDielectricNode().setVisible(false);
            this.addChild(pNode2);
            ((PhetPNode)pNode2).setOffset(cLModelViewTransform3D.modelToView(object2.getLocation()));
            String string = MessageFormat.format(CLStrings.PATTERN_CAPACITOR_NUMBER, n);
            pNode = new HTMLNode(string);
            ((HTMLNode)pNode).setFont(new PhetFont(24));
            ++n;
            this.addChild(pNode);
            pNode2.addPropertyChangeListener("fullBounds", new PropertyChangeListener((HTMLNode)pNode, (CapacitorNode)pNode2){
                final /* synthetic */ HTMLNode val$labelNode;
                final /* synthetic */ CapacitorNode val$capacitorNode;
                {
                    this.val$labelNode = hTMLNode;
                    this.val$capacitorNode = capacitorNode;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    MultipleCapacitorsCircuitNode.updateLabelOffset(this.val$labelNode, this.val$capacitorNode);
                }
            });
            MultipleCapacitorsCircuitNode.updateLabelOffset(pNode, (CapacitorNode)pNode2);
            CapacitanceControlNode capacitanceControlNode = new CapacitanceControlNode(object2, CLConstants.CAPACITANCE_RANGE, -13);
            this.addChild(capacitanceControlNode);
            d6 = pNode2.getFullBoundsReference().getMinX() - capacitanceControlNode.getFullBoundsReference().getWidth() - PNodeLayoutUtils.getOriginXOffset(capacitanceControlNode) + 20.0;
            d5 = pNode2.getYOffset() - capacitanceControlNode.getFullBoundsReference().getHeight() / 2.0 + 20.0;
            capacitanceControlNode.setOffset(d6, d5);
        }
        ArrayList<Wire> arrayList = iCircuit.getWires();
        Object var19_16 = null;
        pNode2 = null;
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            pNode = new WireNode((Wire)arrayList.get(i));
            this.addChild(pNode);
            if (i == arrayList.size() - 1) {
                pNode2 = pNode;
                continue;
            }
            if (i != 0) continue;
            WireNode wireNode = pNode;
        }
        CurrentIndicatorNode currentIndicatorNode = new CurrentIndicatorNode(iCircuit, 0.0);
        currentIndicatorNode.scale(0.75);
        this.addChild(currentIndicatorNode);
        double d7 = cLModelViewTransform3D.modelToViewDelta(0.0, var19_17.getWire().getThickness(), 0.0).getY();
        d6 = iCircuit.getBattery().getX() + (iCircuit.getCapacitors().get(0).getX() - iCircuit.getBattery().getX()) / 2.0;
        d5 = cLModelViewTransform3D.modelToViewDelta(d6, 0.0, 0.0).getX();
        double d8 = var19_17.getFullBoundsReference().getMinY() + d7 / 2.0;
        currentIndicatorNode.setOffset(d5, d8);
        CurrentIndicatorNode currentIndicatorNode2 = new CurrentIndicatorNode(iCircuit, Math.PI);
        currentIndicatorNode2.scale(0.75);
        this.addChild(currentIndicatorNode2);
        double d9 = cLModelViewTransform3D.modelToViewDelta(0.0, ((WireNode)pNode2).getWire().getThickness(), 0.0).getY();
        double d10 = currentIndicatorNode.getXOffset();
        double d11 = pNode2.getFullBoundsReference().getMaxY() - d9 / 2.0;
        currentIndicatorNode2.setOffset(d10, d11);
    }

    public ICircuit getCircuit() {
        return this.circuit;
    }

    private static void updateLabelOffset(PNode pNode, CapacitorNode capacitorNode) {
        double d = capacitorNode.getFullBoundsReference().getMinX();
        double d2 = capacitorNode.getFullBoundsReference().getMinY() - pNode.getFullBoundsReference().getHeight() + 5.0;
        pNode.setOffset(d, d2);
    }
}

