/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.view;

import edu.colorado.phet.capacitorlab.CLConstants;
import edu.colorado.phet.capacitorlab.drag.DielectricOffsetDragHandler;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.model.DielectricChargeView;
import edu.colorado.phet.capacitorlab.view.DielectricNode;
import edu.colorado.phet.capacitorlab.view.EFieldNode;
import edu.colorado.phet.capacitorlab.view.PlateNode;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapacitorNode
extends PhetPNode {
    private final Capacitor capacitor;
    private final CLModelViewTransform3D mvt;
    private final PlateNode topPlateNode;
    private final PlateNode bottomPlateNode;
    private final DielectricNode dielectricNode;
    private final EFieldNode eFieldNode;

    public CapacitorNode(Capacitor capacitor, CLModelViewTransform3D cLModelViewTransform3D, boolean bl, final Property<Boolean> property, final Property<Boolean> property2, Property<DielectricChargeView> property3, double d, double d2, double d3, double d4) {
        this.capacitor = capacitor;
        this.mvt = cLModelViewTransform3D;
        this.topPlateNode = new PlateNode.TopPlateNode(capacitor, cLModelViewTransform3D, d);
        this.bottomPlateNode = new PlateNode.BottomPlateNode(capacitor, cLModelViewTransform3D, d);
        this.dielectricNode = new DielectricNode(capacitor, cLModelViewTransform3D, property3, d2, d4);
        this.eFieldNode = new EFieldNode(capacitor, cLModelViewTransform3D, d3);
        this.addChild(this.bottomPlateNode);
        this.addChild(this.eFieldNode);
        this.addChild(this.dielectricNode);
        this.addChild(this.topPlateNode);
        this.dielectricNode.setVisible(bl);
        if (bl) {
            this.dielectricNode.addInputEventListener(new CursorHandler(11));
            this.dielectricNode.addInputEventListener(new DielectricOffsetDragHandler(this, capacitor, cLModelViewTransform3D, CLConstants.DIELECTRIC_OFFSET_RANGE));
        }
        SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                CapacitorNode.this.updateGeometry();
            }
        };
        capacitor.addPlateSizeObserver(simpleObserver);
        capacitor.addPlateSeparationObserver(simpleObserver);
        capacitor.addDielectricOffsetObserver(simpleObserver);
        property.addObserver(new SimpleObserver(){

            public void update() {
                CapacitorNode.this.topPlateNode.setChargeVisible((Boolean)property.get());
                CapacitorNode.this.bottomPlateNode.setChargeVisible((Boolean)property.get());
            }
        });
        property2.addObserver(new SimpleObserver(){

            public void update() {
                CapacitorNode.this.eFieldNode.setVisible((Boolean)property2.get());
            }
        });
    }

    public DielectricNode getDielectricNode() {
        return this.dielectricNode;
    }

    private void updateGeometry() {
        this.topPlateNode.setBoxSize(this.capacitor.getPlateSize());
        this.bottomPlateNode.setBoxSize(this.capacitor.getPlateSize());
        this.dielectricNode.setBoxSize(this.capacitor.getDielectricSize());
        double d = 0.0;
        double d2 = -(this.capacitor.getPlateSeparation() / 2.0) - this.capacitor.getPlateHeight();
        double d3 = 0.0;
        this.topPlateNode.setOffset(this.mvt.modelToViewDelta(d, d2, d3));
        d2 = -this.capacitor.getDielectricSize().getHeight() / 2.0;
        this.dielectricNode.setOffset(this.mvt.modelToViewDelta(d, d2, d3));
        d2 = this.capacitor.getPlateSeparation() / 2.0;
        this.bottomPlateNode.setOffset(this.mvt.modelToViewDelta(d, d2, d3));
        this.updateDielectricOffset();
    }

    private void updateDielectricOffset() {
        double d = this.capacitor.getDielectricOffset();
        double d2 = -this.capacitor.getDielectricSize().getHeight() / 2.0;
        double d3 = 0.0;
        this.dielectricNode.setOffset(this.mvt.modelToViewDelta(d, d2, d3));
    }
}

