/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.shapes;

import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.wire.Wire;
import edu.colorado.phet.capacitorlab.model.wire.WireSegment;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Line2D;

public class WireShapeCreator {
    private final Wire wire;
    private final CLModelViewTransform3D mvt;

    public WireShapeCreator(Wire wire, CLModelViewTransform3D cLModelViewTransform3D) {
        this.wire = wire;
        this.mvt = cLModelViewTransform3D;
    }

    public Shape createWireShape() {
        Area area = new Area();
        for (WireSegment wireSegment : this.wire.getSegments()) {
            Shape shape = this.createWireSegmentShape(wireSegment, this.wire.getThickness());
            area.add(new Area(shape));
        }
        return area;
    }

    private Shape createWireSegmentShape(WireSegment wireSegment, double d) {
        Line2D.Double double_ = new Line2D.Double(wireSegment.startPointProperty.get(), wireSegment.endPointProperty.get());
        BasicStroke basicStroke = new BasicStroke((float)d, 1, 0);
        Area area = new Area(basicStroke.createStrokedShape(double_));
        return this.mvt.modelToView(area);
    }

    public double getCornerOffset() {
        return 0.0;
    }

    public double getEndOffset() {
        return this.wire.getThickness() / 2.0;
    }
}

