/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.shapes;

import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.shapes.BoxShapeCreator;
import edu.colorado.phet.common.phetcommon.math.Dimension3D;
import edu.colorado.phet.common.phetcommon.view.util.ShapeUtils;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class CapacitorShapeCreator {
    private final Capacitor capacitor;
    private final BoxShapeCreator boxShapeCreator;

    public CapacitorShapeCreator(Capacitor capacitor, CLModelViewTransform3D cLModelViewTransform3D) {
        this.capacitor = capacitor;
        this.boxShapeCreator = new BoxShapeCreator(cLModelViewTransform3D);
    }

    private Shape createTopPlateShape() {
        return this.createBoxShape(this.capacitor.getX(), this.capacitor.getTopPlateCenter().getY(), this.capacitor.getZ(), this.capacitor.getPlateSize());
    }

    public Shape createBottomPlateShape() {
        return this.createBoxShape(this.capacitor.getX(), this.capacitor.getY() + this.capacitor.getPlateSeparation() / 2.0, this.capacitor.getZ(), this.capacitor.getPlateSize());
    }

    private Shape createDielectricShape() {
        return this.createBoxShape(this.capacitor.getX() + this.capacitor.getDielectricOffset(), this.capacitor.getY() - this.capacitor.getDielectricSize().getHeight() / 2.0, this.capacitor.getZ(), this.capacitor.getDielectricSize());
    }

    private Shape createBetweenPlatesShape() {
        return this.createBoxShape(this.capacitor.getX(), this.capacitor.getY() - this.capacitor.getPlateSeparation() / 2.0, this.capacitor.getZ(), this.capacitor.getDielectricSize());
    }

    private Shape createDielectricBetweenPlatesShape() {
        if (this.capacitor.getDielectricOffset() >= this.capacitor.getPlateWidth()) {
            return this.createEmptyShape();
        }
        return ShapeUtils.intersect(this.createDielectricShape(), this.createBetweenPlatesShape());
    }

    private Shape createAirBetweenPlateShape() {
        if (this.capacitor.getDielectricOffset() == 0.0) {
            return this.createEmptyShape();
        }
        return ShapeUtils.subtract(this.createBetweenPlatesShape(), this.createDielectricBetweenPlatesShape());
    }

    public Shape createTopPlateShapeOccluded() {
        return this.createTopPlateShape();
    }

    public Shape createBottomPlateShapeOccluded() {
        return ShapeUtils.subtract(this.createBottomPlateShape(), this.createTopPlateShape());
    }

    public Shape createDielectricBetweenPlatesShapeOccluded() {
        return ShapeUtils.subtract(this.createDielectricBetweenPlatesShape(), this.createTopPlateShape());
    }

    public Shape createAirBetweenPlatesShapeOccluded() {
        return ShapeUtils.subtract(this.createAirBetweenPlateShape(), this.createTopPlateShape());
    }

    private Shape createBoxShape(double d, double d2, double d3, Dimension3D dimension3D) {
        return this.boxShapeCreator.createBoxShape(d, d2, d3, dimension3D.getWidth(), dimension3D.getHeight(), dimension3D.getDepth());
    }

    private Shape createEmptyShape() {
        return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    }
}

