/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.shapes;

import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.common.phetcommon.math.Dimension3D;
import edu.colorado.phet.common.phetcommon.view.util.ShapeUtils;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class BoxShapeCreator {
    private final CLModelViewTransform3D mvt;

    public BoxShapeCreator(CLModelViewTransform3D cLModelViewTransform3D) {
        this.mvt = cLModelViewTransform3D;
    }

    private Shape createTopFace(double d, double d2, double d3, double d4, double d5, double d6) {
        Point2D point2D = this.mvt.modelToView(d - d4 / 2.0, d2, d3 + d6 / 2.0);
        Point2D point2D2 = this.mvt.modelToView(d + d4 / 2.0, d2, d3 + d6 / 2.0);
        Point2D point2D3 = this.mvt.modelToView(d + d4 / 2.0, d2, d3 - d6 / 2.0);
        Point2D point2D4 = this.mvt.modelToView(d - d4 / 2.0, d2, d3 - d6 / 2.0);
        return this.createFace(point2D, point2D2, point2D3, point2D4);
    }

    public Shape createTopFace(Dimension3D dimension3D) {
        return this.createTopFace(0.0, 0.0, 0.0, dimension3D.getWidth(), dimension3D.getHeight(), dimension3D.getDepth());
    }

    public Shape createBottomFace(Dimension3D dimension3D) {
        return this.createTopFace(0.0, dimension3D.getHeight(), 0.0, dimension3D.getWidth(), dimension3D.getHeight(), dimension3D.getDepth());
    }

    private Shape createFrontFace(double d, double d2, double d3, double d4, double d5, double d6) {
        Point2D point2D = this.mvt.modelToView(d - d4 / 2.0, d2, d3 - d6 / 2.0);
        Point2D point2D2 = this.mvt.modelToView(d + d4 / 2.0, d2, d3 - d6 / 2.0);
        Point2D point2D3 = this.mvt.modelToView(d + d4 / 2.0, d2 + d5, d3 - d6 / 2.0);
        Point2D point2D4 = this.mvt.modelToView(d - d4 / 2.0, d2 + d5, d3 - d6 / 2.0);
        return this.createFace(point2D, point2D2, point2D3, point2D4);
    }

    public Shape createFrontFace(Dimension3D dimension3D) {
        return this.createFrontFace(0.0, 0.0, 0.0, dimension3D.getWidth(), dimension3D.getHeight(), dimension3D.getDepth());
    }

    public Shape createBackFace(Dimension3D dimension3D) {
        return this.createFrontFace(0.0, 0.0, dimension3D.getDepth(), dimension3D.getWidth(), dimension3D.getHeight(), dimension3D.getDepth());
    }

    private Shape createRightSideFace(double d, double d2, double d3, double d4, double d5, double d6) {
        Point2D point2D = this.mvt.modelToView(d + d4 / 2.0, d2, d3 - d6 / 2.0);
        Point2D point2D2 = this.mvt.modelToView(d + d4 / 2.0, d2, d3 + d6 / 2.0);
        Point2D point2D3 = this.mvt.modelToView(d + d4 / 2.0, d2 + d5, d3 + d6 / 2.0);
        Point2D point2D4 = this.mvt.modelToView(d + d4 / 2.0, d2 + d5, d3 - d6 / 2.0);
        return this.createFace(point2D, point2D2, point2D3, point2D4);
    }

    public Shape createRightSideFace(Dimension3D dimension3D) {
        return this.createRightSideFace(0.0, 0.0, 0.0, dimension3D.getWidth(), dimension3D.getHeight(), dimension3D.getDepth());
    }

    public Shape createLeftSideFace(Dimension3D dimension3D) {
        return this.createRightSideFace(-dimension3D.getWidth(), 0.0, 0.0, dimension3D.getWidth(), dimension3D.getHeight(), dimension3D.getDepth());
    }

    public Shape createBoxShape(double d, double d2, double d3, double d4, double d5, double d6) {
        Shape shape = this.createTopFace(d, d2, d3, d4, d5, d6);
        Shape shape2 = this.createFrontFace(d, d2, d3, d4, d5, d6);
        Shape shape3 = this.createRightSideFace(d, d2, d3, d4, d5, d6);
        return ShapeUtils.add(shape, shape2, shape3);
    }

    private Shape createFace(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.reset();
        generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
        generalPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
        generalPath.lineTo((float)point2D3.getX(), (float)point2D3.getY());
        generalPath.lineTo((float)point2D4.getX(), (float)point2D4.getY());
        generalPath.closePath();
        return generalPath;
    }
}

