/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.module.dielectric;

import edu.colorado.phet.capacitorlab.CLConstants;
import edu.colorado.phet.capacitorlab.CLGlobalProperties;
import edu.colorado.phet.capacitorlab.CLStrings;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.DielectricMaterial;
import edu.colorado.phet.capacitorlab.module.CLModule;
import edu.colorado.phet.capacitorlab.module.dielectric.DielectricCanvas;
import edu.colorado.phet.capacitorlab.module.dielectric.DielectricControlPanel;
import edu.colorado.phet.capacitorlab.module.dielectric.DielectricModel;

public class DielectricModule
extends CLModule {
    private final DielectricModel model;
    private final DielectricCanvas canvas;

    public DielectricModule(CLGlobalProperties cLGlobalProperties) {
        this(CLStrings.DIELECTRIC, cLGlobalProperties);
    }

    protected DielectricModule(String string, CLGlobalProperties cLGlobalProperties) {
        super(string);
        CLModelViewTransform3D cLModelViewTransform3D = new CLModelViewTransform3D();
        DielectricMaterial[] dielectricMaterialArray = new DielectricMaterial[]{new DielectricMaterial.CustomDielectricMaterial(), new DielectricMaterial.Teflon(), new DielectricMaterial.Paper(), new DielectricMaterial.Glass()};
        this.model = new DielectricModel(this.getClock(), cLModelViewTransform3D, CLConstants.DIELECTRIC_OFFSET_RANGE.getDefault(), dielectricMaterialArray);
        this.canvas = new DielectricCanvas(this.model, cLModelViewTransform3D, cLGlobalProperties, false, true);
        this.setSimulationPanel(this.canvas);
        this.setControlPanel(new DielectricControlPanel(this, this.model, this.canvas, cLGlobalProperties));
    }

    public void reset() {
        super.reset();
        this.model.reset();
        this.canvas.reset();
    }
}

