/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.module.dielectric;

import edu.colorado.phet.capacitorlab.CLConstants;
import edu.colorado.phet.capacitorlab.model.CLClock;
import edu.colorado.phet.capacitorlab.model.CLModel;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.model.CircuitConfig;
import edu.colorado.phet.capacitorlab.model.DielectricMaterial;
import edu.colorado.phet.capacitorlab.model.circuit.SingleCircuit;
import edu.colorado.phet.capacitorlab.model.meter.BarMeter;
import edu.colorado.phet.capacitorlab.model.meter.EFieldDetector;
import edu.colorado.phet.capacitorlab.model.meter.Voltmeter;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;

public class DielectricModel
extends CLModel {
    private static final Point3D BATTERY_LOCATION = new Point3D.Double(0.005, 0.034, 0.0);
    private static final double PLATE_WIDTH = CLConstants.PLATE_WIDTH_RANGE.getDefault();
    private static final double PLATE_SEPARATION = CLConstants.PLATE_SEPARATION_RANGE.getDefault();
    public static final Point3D CAPACITANCE_METER_LOCATION = new Point3D.Double(0.038, 0.0017, 0.0);
    public static final Point3D PLATE_CHARGE_METER_LOCATION = new Point3D.Double(0.049, 0.0017, 0.0);
    public static final Point3D STORED_ENERGY_METER_LOCATION = new Point3D.Double(0.06, 0.0017, 0.0);
    public static final Point3D EFIELD_DETECTOR_BODY_LOCATION = new Point3D.Double(0.043, 0.041, 0.0);
    public static final Point3D EFIELD_DETECTOR_PROBE_LOCATION = BATTERY_LOCATION;
    public static final Point3D VOLTMETER_BODY_LOCATION = new Point3D.Double(0.057, 0.023, 0.0);
    public static final Point3D VOLTMETER_POSITIVE_PROBE_LOCATION = new Point3D.Double(BATTERY_LOCATION.getX() + 0.015, BATTERY_LOCATION.getY(), BATTERY_LOCATION.getZ());
    public static final Point3D VOLTMETER_NEGATIVE_PROBE_LOCATION = new Point3D.Double(VOLTMETER_POSITIVE_PROBE_LOCATION.getX() + 0.005, VOLTMETER_POSITIVE_PROBE_LOCATION.getY(), VOLTMETER_POSITIVE_PROBE_LOCATION.getZ());
    public final DielectricMaterial[] dielectricMaterials;
    public final SingleCircuit circuit;
    public final BarMeter.CapacitanceMeter capacitanceMeter;
    public final BarMeter.PlateChargeMeter plateChargeMeter;
    public final BarMeter.StoredEnergyMeter storedEnergyMeter;
    public final EFieldDetector eFieldDetector;
    public final Voltmeter voltmeter;

    public DielectricModel(IClock iClock, CLModelViewTransform3D cLModelViewTransform3D, double d, DielectricMaterial[] dielectricMaterialArray) {
        this.dielectricMaterials = dielectricMaterialArray;
        CircuitConfig circuitConfig = new CircuitConfig(iClock, cLModelViewTransform3D, BATTERY_LOCATION, 0.025, 0.0, PLATE_WIDTH, PLATE_SEPARATION, dielectricMaterialArray[0], d, 5.0E-4, 0.016);
        this.circuit = new SingleCircuit(circuitConfig, true);
        this.capacitanceMeter = new BarMeter.CapacitanceMeter(this.circuit, this.getWorldBounds(), CAPACITANCE_METER_LOCATION, false);
        this.plateChargeMeter = new BarMeter.PlateChargeMeter(this.circuit, this.getWorldBounds(), PLATE_CHARGE_METER_LOCATION, false);
        this.storedEnergyMeter = new BarMeter.StoredEnergyMeter(this.circuit, this.getWorldBounds(), STORED_ENERGY_METER_LOCATION, false);
        this.eFieldDetector = new EFieldDetector(this.circuit, this.getWorldBounds(), cLModelViewTransform3D, EFIELD_DETECTOR_BODY_LOCATION, EFIELD_DETECTOR_PROBE_LOCATION, false, true, true, true, true);
        this.voltmeter = new Voltmeter(this.circuit, this.getWorldBounds(), cLModelViewTransform3D, VOLTMETER_BODY_LOCATION, VOLTMETER_POSITIVE_PROBE_LOCATION, VOLTMETER_NEGATIVE_PROBE_LOCATION, false);
    }

    public void reset() {
        for (DielectricMaterial dielectricMaterial : this.dielectricMaterials) {
            dielectricMaterial.reset();
        }
        this.capacitanceMeter.reset();
        this.plateChargeMeter.reset();
        this.storedEnergyMeter.reset();
        this.eFieldDetector.reset();
        this.voltmeter.reset();
        this.circuit.reset();
    }

    public static double getMaxPlateCharge() {
        return DielectricModel.getCapacitorWithMaxCharge().getTotalPlateCharge();
    }

    public static double getMaxExcessDielectricPlateCharge() {
        return DielectricModel.getCapacitorWithMaxCharge().getExcessDielectricPlateCharge();
    }

    private static Capacitor getCapacitorWithMaxCharge() {
        CLModelViewTransform3D cLModelViewTransform3D = new CLModelViewTransform3D();
        DielectricMaterial.CustomDielectricMaterial customDielectricMaterial = new DielectricMaterial.CustomDielectricMaterial(CLConstants.DIELECTRIC_CONSTANT_RANGE.getMax());
        Capacitor capacitor = new Capacitor(new Point3D.Double(), CLConstants.PLATE_WIDTH_RANGE.getMax(), CLConstants.PLATE_SEPARATION_RANGE.getMin(), customDielectricMaterial, CLConstants.DIELECTRIC_OFFSET_RANGE.getMin(), cLModelViewTransform3D);
        capacitor.setPlatesVoltage(CLConstants.BATTERY_VOLTAGE_RANGE.getMax());
        return capacitor;
    }

    public static double getMaxEffectiveEField() {
        CircuitConfig circuitConfig = new CircuitConfig(new CLClock(), new CLModelViewTransform3D(), new Point3D.Double(), 0.025, 0.0, CLConstants.PLATE_WIDTH_RANGE.getMin(), CLConstants.PLATE_SEPARATION_RANGE.getMin(), new DielectricMaterial.CustomDielectricMaterial(CLConstants.DIELECTRIC_CONSTANT_RANGE.getMin()), CLConstants.DIELECTRIC_OFFSET_RANGE.getMin(), 5.0E-4, 0.016);
        SingleCircuit singleCircuit = new SingleCircuit(circuitConfig, false);
        singleCircuit.setDisconnectedPlateCharge(DielectricModel.getMaxPlateCharge());
        return singleCircuit.getCapacitor().getEffectiveEField();
    }

    public static double getMaxDielectricEField() {
        CircuitConfig circuitConfig = new CircuitConfig(new CLClock(), new CLModelViewTransform3D(), new Point3D.Double(), 0.025, 0.0, CLConstants.PLATE_WIDTH_RANGE.getMin(), CLConstants.PLATE_SEPARATION_RANGE.getMin(), new DielectricMaterial.CustomDielectricMaterial(CLConstants.DIELECTRIC_CONSTANT_RANGE.getMax()), CLConstants.DIELECTRIC_OFFSET_RANGE.getMin(), 5.0E-4, 0.016);
        SingleCircuit singleCircuit = new SingleCircuit(circuitConfig, false);
        singleCircuit.setDisconnectedPlateCharge(DielectricModel.getMaxPlateCharge());
        return singleCircuit.getCapacitor().getDielectricEField();
    }

    public static double getEFieldReferenceMagnitude() {
        Capacitor capacitor = new Capacitor(new Point3D.Double(), CLConstants.PLATE_WIDTH_RANGE.getDefault(), CLConstants.PLATE_SEPARATION_RANGE.getDefault(), new DielectricMaterial.CustomDielectricMaterial(CLConstants.DIELECTRIC_CONSTANT_RANGE.getDefault()), CLConstants.DIELECTRIC_OFFSET_RANGE.getDefault(), new CLModelViewTransform3D());
        capacitor.setPlatesVoltage(CLConstants.BATTERY_VOLTAGE_RANGE.getMax());
        return capacitor.getEffectiveEField();
    }
}

