/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.model.wire;

import edu.colorado.phet.capacitorlab.model.Battery;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.awt.geom.Point2D;

public class WireSegment {
    public final Property<Point2D> startPointProperty;
    public final Property<Point2D> endPointProperty;

    public WireSegment(Point2D point2D, Point2D point2D2) {
        this(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public WireSegment(double d, double d2, double d3, double d4) {
        this.startPointProperty = new Property<Point2D.Double>(new Point2D.Double(d, d2));
        this.endPointProperty = new Property<Point2D.Double>(new Point2D.Double(d3, d4));
    }

    public static class BatteryBottomWireSegment
    extends BatteryWireSegment {
        public BatteryBottomWireSegment(Battery battery, double d, Point2D point2D) {
            super(battery, d, new Point2D.Double(battery.getX(), battery.getY() + battery.getBottomTerminalYOffset()), point2D);
        }

        public void update() {
            Battery battery = this.getBattery();
            this.startPointProperty.set(new Point2D.Double(battery.getX(), battery.getY() + battery.getBottomTerminalYOffset() + this.getStartYOffset()));
        }
    }

    public static class BatteryTopWireSegment
    extends BatteryWireSegment {
        public BatteryTopWireSegment(Battery battery, double d, Point2D point2D) {
            super(battery, d, new Point2D.Double(battery.getX(), battery.getY() + battery.getTopTerminalYOffset()), point2D);
        }

        public void update() {
            Battery battery = this.getBattery();
            this.startPointProperty.set(new Point2D.Double(battery.getX(), battery.getY() + battery.getTopTerminalYOffset() - this.getStartYOffset()));
        }
    }

    private static abstract class BatteryWireSegment
    extends WireSegment
    implements SimpleObserver {
        private final Battery battery;
        private final double startYOffset;

        public BatteryWireSegment(Battery battery, double d, Point2D point2D, Point2D point2D2) {
            super(point2D, point2D2);
            this.battery = battery;
            this.startYOffset = d;
            battery.addPolarityObserver(this);
        }

        protected Battery getBattery() {
            return this.battery;
        }

        protected double getStartYOffset() {
            return this.startYOffset;
        }
    }

    public static class CapacitorBottomWireSegment
    extends CapacitorWireSegment {
        public CapacitorBottomWireSegment(Capacitor capacitor, Point2D point2D) {
            super(capacitor, new Point2D.Double(capacitor.getBottomPlateCenter().getX(), capacitor.getBottomPlateCenter().getY()), point2D);
        }

        public void update() {
            Capacitor capacitor = this.getCapacitor();
            this.startPointProperty.set(new Point2D.Double(capacitor.getBottomPlateCenter().getX(), capacitor.getBottomPlateCenter().getY()));
        }
    }

    public static class CapacitorToCapacitorWireSegment
    extends WireSegment
    implements SimpleObserver {
        private final Capacitor topCapacitor;
        private final Capacitor bottomCapacitor;

        public CapacitorToCapacitorWireSegment(Capacitor capacitor, Capacitor capacitor2) {
            super(new Point2D.Double(capacitor.getBottomPlateCenter().getX(), capacitor.getBottomPlateCenter().getY()), new Point2D.Double(capacitor2.getTopPlateCenter().getX(), capacitor2.getTopPlateCenter().getY()));
            this.topCapacitor = capacitor;
            this.bottomCapacitor = capacitor2;
            capacitor.addPlateSeparationObserver(this);
            capacitor2.addPlateSeparationObserver(this);
        }

        public void update() {
            this.startPointProperty.set(new Point2D.Double(this.topCapacitor.getBottomPlateCenter().getX(), this.topCapacitor.getBottomPlateCenter().getY()));
            this.endPointProperty.set(new Point2D.Double(this.bottomCapacitor.getTopPlateCenter().getX(), this.bottomCapacitor.getTopPlateCenter().getY()));
        }
    }

    public static class CapacitorTopWireSegment
    extends CapacitorWireSegment {
        public CapacitorTopWireSegment(Capacitor capacitor, Point2D point2D) {
            super(capacitor, new Point2D.Double(capacitor.getTopPlateCenter().getX(), capacitor.getTopPlateCenter().getY()), point2D);
        }

        public void update() {
            Capacitor capacitor = this.getCapacitor();
            this.startPointProperty.set(new Point2D.Double(capacitor.getTopPlateCenter().getX(), capacitor.getTopPlateCenter().getY()));
        }
    }

    private static abstract class CapacitorWireSegment
    extends WireSegment
    implements SimpleObserver {
        private final Capacitor capacitor;

        public CapacitorWireSegment(Capacitor capacitor, Point2D point2D, Point2D point2D2) {
            super(point2D, point2D2);
            this.capacitor = capacitor;
            capacitor.addPlateSeparationObserver(this);
        }

        protected Capacitor getCapacitor() {
            return this.capacitor;
        }
    }
}

