/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.model.meter;

import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.model.WorldBounds;
import edu.colorado.phet.capacitorlab.model.WorldLocationProperty;
import edu.colorado.phet.capacitorlab.model.circuit.ICircuit;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.awt.Shape;
import java.awt.geom.Point2D;

public class EFieldDetector {
    public final Property<Boolean> visibleProperty;
    public final WorldLocationProperty bodyLocationProperty;
    public final WorldLocationProperty probeLocationProperty;
    public final Property<Boolean> plateVisibleProperty;
    public final Property<Boolean> dielectricVisibleProperty;
    public final Property<Boolean> sumVisibleProperty;
    public final Property<Boolean> valuesVisibleProperty;
    private final Property<Double> plateVectorProperty;
    private final Property<Double> dielectricVectorProperty;
    private final Property<Double> sumVectorProperty;
    private ICircuit circuit;
    private final CLModelViewTransform3D mvt;
    private final ICircuit.CircuitChangeListener circuitChangeListener;
    private boolean hasBeenVisible;

    public EFieldDetector(ICircuit iCircuit, WorldBounds worldBounds, CLModelViewTransform3D cLModelViewTransform3D, Point3D point3D, Point3D point3D2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.circuit = iCircuit;
        this.mvt = cLModelViewTransform3D;
        this.visibleProperty = new Property<Boolean>(bl);
        this.bodyLocationProperty = new WorldLocationProperty(worldBounds, point3D);
        this.probeLocationProperty = new WorldLocationProperty(worldBounds, point3D2);
        this.plateVectorProperty = new Property<Double>(0.0);
        this.dielectricVectorProperty = new Property<Double>(0.0);
        this.sumVectorProperty = new Property<Double>(0.0);
        this.plateVisibleProperty = new Property<Boolean>(bl2);
        this.dielectricVisibleProperty = new Property<Boolean>(bl3);
        this.sumVisibleProperty = new Property<Boolean>(bl4);
        this.valuesVisibleProperty = new Property<Boolean>(bl5);
        this.circuitChangeListener = new ICircuit.CircuitChangeListener(){

            public void circuitChanged() {
                EFieldDetector.this.updateVectors();
            }
        };
        iCircuit.addCircuitChangeListener(this.circuitChangeListener);
        this.probeLocationProperty.addObserver(new SimpleObserver(){

            public void update() {
                EFieldDetector.this.updateVectors();
            }
        });
        this.hasBeenVisible = bl;
        this.visibleProperty.addObserver(new SimpleObserver(){

            public void update() {
                if (!EFieldDetector.this.hasBeenVisible) {
                    EFieldDetector.this.hasBeenVisible = true;
                    EFieldDetector.this.moveProbe(EFieldDetector.this.circuit.getCapacitors().get(0));
                }
            }
        }, false);
    }

    private void moveProbe(Capacitor capacitor) {
        this.probeLocationProperty.set(capacitor.getLocation());
        if (this.probeIntersectsTopPlate(capacitor)) {
            double d = capacitor.getX();
            double d2 = capacitor.getY() + capacitor.getPlateSeparation() / 2.0;
            double d3 = capacitor.getZ();
            this.probeLocationProperty.set(new Point3D.Double(d, d2, d3));
        }
    }

    private boolean probeIntersectsTopPlate(Capacitor capacitor) {
        Shape shape = capacitor.getShapeCreator().createTopPlateShapeOccluded();
        Point2D point2D = this.mvt.modelToView((Point3D)this.probeLocationProperty.get());
        return shape.contains(point2D);
    }

    public void reset() {
        this.visibleProperty.reset();
        this.hasBeenVisible = this.visibleProperty.get();
        this.bodyLocationProperty.reset();
        this.probeLocationProperty.reset();
        this.plateVisibleProperty.reset();
        this.dielectricVisibleProperty.reset();
        this.sumVisibleProperty.reset();
        this.valuesVisibleProperty.reset();
    }

    public void setCircuit(ICircuit iCircuit) {
        if (iCircuit != this.circuit) {
            this.circuit.removeCircuitChangeListener(this.circuitChangeListener);
            this.circuit = iCircuit;
            this.circuit.addCircuitChangeListener(this.circuitChangeListener);
            this.updateVectors();
        }
    }

    public void addPlateVectorObserver(SimpleObserver simpleObserver) {
        this.plateVectorProperty.addObserver(simpleObserver);
    }

    public double getPlateVector() {
        return this.plateVectorProperty.get();
    }

    public void addDielectricVectorObserver(SimpleObserver simpleObserver) {
        this.dielectricVectorProperty.addObserver(simpleObserver);
    }

    public double getDielectricVector() {
        return this.dielectricVectorProperty.get();
    }

    public void addSumVectorObserver(SimpleObserver simpleObserver) {
        this.sumVectorProperty.addObserver(simpleObserver);
    }

    public double getSumVector() {
        return this.sumVectorProperty.get();
    }

    private void updateVectors() {
        this.plateVectorProperty.set(this.circuit.getPlatesDielectricEFieldAt((Point3D)this.probeLocationProperty.get()));
        this.dielectricVectorProperty.set(this.circuit.getDielectricEFieldAt((Point3D)this.probeLocationProperty.get()));
        this.sumVectorProperty.set(this.circuit.getEffectiveEFieldAt((Point3D)this.probeLocationProperty.get()));
    }
}

