/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.model.circuit;

import edu.colorado.phet.capacitorlab.CLStrings;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.model.CircuitConfig;
import edu.colorado.phet.capacitorlab.model.circuit.ParallelCircuit;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.awt.Shape;

public class SingleCircuit
extends ParallelCircuit {
    private final Capacitor capacitor = this.getCapacitors().get(0);
    private final Property<Boolean> batteryConnectedProperty;
    private double disconnectedPlateCharge;

    public SingleCircuit(CircuitConfig circuitConfig) {
        this(circuitConfig, true);
    }

    public SingleCircuit(CircuitConfig circuitConfig, boolean bl) {
        super(circuitConfig, CLStrings.SINGLE, 1);
        this.batteryConnectedProperty = new Property<Boolean>(bl);
        this.disconnectedPlateCharge = this.getTotalCharge();
        this.batteryConnectedProperty.addObserver(new SimpleObserver(){

            public void update() {
                SingleCircuit.this.updatePlateVoltages();
                SingleCircuit.this.fireCircuitChanged();
            }
        }, false);
        this.updatePlateVoltages();
    }

    public void reset() {
        super.reset();
        this.batteryConnectedProperty.reset();
    }

    public Capacitor getCapacitor() {
        return this.capacitor;
    }

    public void setBatteryConnected(boolean bl) {
        if (bl != this.isBatteryConnected()) {
            if (!bl) {
                this.disconnectedPlateCharge = this.getTotalCharge();
            }
            this.batteryConnectedProperty.set(bl);
        }
    }

    public boolean isBatteryConnected() {
        return this.batteryConnectedProperty.get();
    }

    protected void updatePlateVoltages() {
        if (this.batteryConnectedProperty != null) {
            double d = this.getBattery().getVoltage();
            if (!this.isBatteryConnected()) {
                d = this.disconnectedPlateCharge / this.capacitor.getTotalCapacitance();
            }
            this.capacitor.setPlatesVoltage(d);
        }
    }

    public double getTotalVoltage() {
        if (this.isBatteryConnected()) {
            return super.getTotalVoltage();
        }
        return this.capacitor.getPlatesVoltage();
    }

    public double getVoltageAt(Shape shape) {
        double d = Double.NaN;
        if (this.isBatteryConnected()) {
            d = super.getVoltageAt(shape);
        } else if (this.intersectsSomeTopPlate(shape)) {
            d = this.getTotalVoltage();
        } else if (this.intersectsSomeBottomPlate(shape)) {
            d = 0.0;
        }
        return d;
    }

    public void setDisconnectedPlateCharge(double d) {
        if (d != this.disconnectedPlateCharge) {
            this.disconnectedPlateCharge = d;
            if (!this.isBatteryConnected()) {
                this.updatePlateVoltages();
                this.fireCircuitChanged();
            }
        }
    }

    public double getDisconnectedPlateCharge() {
        return this.disconnectedPlateCharge;
    }

    public double getTotalCharge() {
        return this.capacitor.getTotalPlateCharge();
    }
}

