/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.model.circuit;

import edu.colorado.phet.capacitorlab.model.Battery;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.model.CircuitConfig;
import edu.colorado.phet.capacitorlab.model.circuit.AbstractCircuit;
import edu.colorado.phet.capacitorlab.model.wire.Wire;
import edu.colorado.phet.capacitorlab.model.wire.WireBatteryToCapacitors;
import edu.colorado.phet.capacitorlab.model.wire.WireCapacitorToCapacitors;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import java.awt.Shape;
import java.util.ArrayList;

public class SeriesCircuit
extends AbstractCircuit {
    public SeriesCircuit(CircuitConfig circuitConfig, String string, int n) {
        super(circuitConfig, string, n, new AbstractCircuit.CreateCapacitors(){

            @Override
            public ArrayList<Capacitor> apply(CircuitConfig circuitConfig, Integer n) {
                double d = circuitConfig.batteryLocation.getX() + circuitConfig.capacitorXSpacing;
                double d2 = circuitConfig.batteryLocation.getY() - (double)(n / 2) * circuitConfig.capacitorYSpacing;
                if (n % 2 == 0) {
                    d2 += 0.5 * circuitConfig.capacitorYSpacing;
                }
                double d3 = circuitConfig.batteryLocation.getZ();
                ArrayList<Capacitor> arrayList = new ArrayList<Capacitor>();
                for (int i = 0; i < n; ++i) {
                    Point3D.Double double_ = new Point3D.Double(d, d2, d3);
                    Capacitor capacitor = new Capacitor(double_, circuitConfig.plateWidth, circuitConfig.plateSeparation, circuitConfig.dielectricMaterial, circuitConfig.dielectricOffset, circuitConfig.mvt);
                    arrayList.add(capacitor);
                    d2 += circuitConfig.capacitorYSpacing;
                }
                return arrayList;
            }
        }, new AbstractCircuit.CreateWires(){

            @Override
            public ArrayList<Wire> apply(CircuitConfig circuitConfig, Battery battery, ArrayList<Capacitor> arrayList) {
                ArrayList<Wire> arrayList2 = new ArrayList<Wire>();
                arrayList2.add(new WireBatteryToCapacitors.WireBatteryToCapacitorsTop(circuitConfig.mvt, circuitConfig.wireThickness, circuitConfig.wireExtent, battery, arrayList.get(0)));
                for (int i = 0; i < arrayList.size() - 1; ++i) {
                    arrayList2.add(new WireCapacitorToCapacitors(circuitConfig.mvt, circuitConfig.wireThickness, arrayList.get(i), arrayList.get(i + 1)));
                }
                arrayList2.add(new WireBatteryToCapacitors.WireBatteryToCapacitorsBottom(circuitConfig.mvt, circuitConfig.wireThickness, circuitConfig.wireExtent, battery, arrayList.get(arrayList.size() - 1)));
                assert (arrayList2.size() == arrayList.size() + 1);
                return arrayList2;
            }
        });
        this.updatePlateVoltages();
    }

    protected void updatePlateVoltages() {
        double d = this.getTotalCharge();
        for (Capacitor capacitor : this.getCapacitors()) {
            double d2 = capacitor.getTotalCapacitance();
            double d3 = d / d2;
            capacitor.setPlatesVoltage(d3);
        }
    }

    public double getTotalCapacitance() {
        double d = 0.0;
        for (Capacitor capacitor : this.getCapacitors()) {
            assert (capacitor.getTotalCapacitance() > 0.0);
            d += 1.0 / capacitor.getTotalCapacitance();
        }
        assert (d > 0.0);
        return 1.0 / d;
    }

    public double getVoltageAt(Shape shape) {
        double d = Double.NaN;
        if (this.getBattery().intersectsTopTerminal(shape)) {
            d = this.getTotalVoltage();
        } else if (this.getBattery().intersectsBottomTerminal(shape)) {
            d = 0.0;
        } else {
            ArrayList<Capacitor> arrayList = this.getCapacitors();
            ArrayList<Wire> arrayList2 = this.getWires();
            for (int i = 0; i < arrayList.size(); ++i) {
                Capacitor capacitor = arrayList.get(i);
                Wire wire = arrayList2.get(i);
                Wire wire2 = arrayList2.get(i + 1);
                if (capacitor.intersectsTopPlate(shape) || wire.intersects(shape)) {
                    d = this.sumPlateVoltages(i);
                    continue;
                }
                if (!capacitor.intersectsBottomPlate(shape) && !wire2.intersects(shape)) continue;
                d = this.sumPlateVoltages(i + 1);
            }
        }
        return d;
    }

    private double sumPlateVoltages(int n) {
        double d = 0.0;
        ArrayList<Capacitor> arrayList = this.getCapacitors();
        for (int i = n; i < arrayList.size(); ++i) {
            d += arrayList.get(i).getPlatesVoltage();
        }
        return d;
    }
}

