/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.model.circuit;

import edu.colorado.phet.capacitorlab.model.Battery;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.model.CircuitConfig;
import edu.colorado.phet.capacitorlab.model.circuit.AbstractCircuit;
import edu.colorado.phet.capacitorlab.model.wire.Wire;
import edu.colorado.phet.capacitorlab.model.wire.WireBatteryToCapacitors;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import java.awt.Shape;
import java.util.ArrayList;

public class ParallelCircuit
extends AbstractCircuit {
    public ParallelCircuit(CircuitConfig circuitConfig, String string, int n) {
        super(circuitConfig, string, n, new AbstractCircuit.CreateCapacitors(){

            @Override
            public ArrayList<Capacitor> apply(CircuitConfig circuitConfig, Integer n) {
                double d = circuitConfig.batteryLocation.getX() + circuitConfig.capacitorXSpacing;
                double d2 = circuitConfig.batteryLocation.getY();
                double d3 = circuitConfig.batteryLocation.getZ();
                ArrayList<Capacitor> arrayList = new ArrayList<Capacitor>();
                for (int i = 0; i < n; ++i) {
                    Point3D.Double double_ = new Point3D.Double(d, d2, d3);
                    Capacitor capacitor = new Capacitor(double_, circuitConfig.plateWidth, circuitConfig.plateSeparation, circuitConfig.dielectricMaterial, circuitConfig.dielectricOffset, circuitConfig.mvt);
                    arrayList.add(capacitor);
                    d += circuitConfig.capacitorXSpacing;
                }
                return arrayList;
            }
        }, new AbstractCircuit.CreateWires(){

            @Override
            public ArrayList<Wire> apply(final CircuitConfig circuitConfig, final Battery battery, final ArrayList<Capacitor> arrayList) {
                return new ArrayList<Wire>(){
                    {
                        this.add(new WireBatteryToCapacitors.WireBatteryToCapacitorsTop(circuitConfig.mvt, circuitConfig.wireThickness, circuitConfig.wireExtent, battery, arrayList));
                        this.add(new WireBatteryToCapacitors.WireBatteryToCapacitorsBottom(circuitConfig.mvt, circuitConfig.wireThickness, circuitConfig.wireExtent, battery, arrayList));
                    }
                };
            }
        });
        this.updatePlateVoltages();
    }

    protected void updatePlateVoltages() {
        for (Capacitor capacitor : this.getCapacitors()) {
            capacitor.setPlatesVoltage(this.getTotalVoltage());
        }
    }

    public double getTotalCapacitance() {
        double d = 0.0;
        for (Capacitor capacitor : this.getCapacitors()) {
            d += capacitor.getTotalCapacitance();
        }
        return d;
    }

    public double getVoltageAt(Shape shape) {
        double d = Double.NaN;
        if (this.connectedToBatteryTop(shape)) {
            d = this.getTotalVoltage();
        } else if (this.connectedToBatteryBottom(shape)) {
            d = 0.0;
        }
        return d;
    }

    protected boolean connectedToBatteryTop(Shape shape) {
        return this.getBattery().intersectsTopTerminal(shape) || this.getTopWire().intersects(shape) || this.intersectsSomeTopPlate(shape);
    }

    protected boolean connectedToBatteryBottom(Shape shape) {
        return this.getBattery().intersectsBottomTerminal(shape) || this.getBottomWire().intersects(shape) || this.intersectsSomeBottomPlate(shape);
    }

    protected boolean intersectsSomeTopPlate(Shape shape) {
        boolean bl = false;
        for (Capacitor capacitor : this.getCapacitors()) {
            if (!capacitor.intersectsTopPlate(shape)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected boolean intersectsSomeBottomPlate(Shape shape) {
        boolean bl = false;
        for (Capacitor capacitor : this.getCapacitors()) {
            if (!capacitor.intersectsBottomPlate(shape)) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

