/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.model.circuit;

import edu.colorado.phet.capacitorlab.model.Battery;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.model.wire.Wire;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.awt.Shape;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ICircuit {
    public Battery getBattery();

    public boolean isBatteryConnected();

    public ArrayList<Capacitor> getCapacitors();

    public ArrayList<Wire> getWires();

    public String getDisplayName();

    public double getTotalCapacitance();

    public double getTotalCharge();

    public double getStoredEnergy();

    public double getVoltageBetween(Shape var1, Shape var2);

    public double getVoltageAt(Shape var1);

    public double getEffectiveEFieldAt(Point3D var1);

    public double getPlatesDielectricEFieldAt(Point3D var1);

    public double getDielectricEFieldAt(Point3D var1);

    public double getCurrentAmplitude();

    public void addCurrentAmplitudeObserver(SimpleObserver var1);

    public void addCircuitChangeListener(CircuitChangeListener var1);

    public void removeCircuitChangeListener(CircuitChangeListener var1);

    public void reset();

    public static interface CircuitChangeListener {
        public void circuitChanged();
    }
}

