/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.model.circuit;

import edu.colorado.phet.capacitorlab.CLConstants;
import edu.colorado.phet.capacitorlab.model.Battery;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.model.CircuitConfig;
import edu.colorado.phet.capacitorlab.model.circuit.ICircuit;
import edu.colorado.phet.capacitorlab.model.wire.Wire;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.awt.Shape;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCircuit
implements ICircuit {
    private final String displayName;
    private final IClock clock;
    private final ClockAdapter clockListener;
    private final Battery battery;
    private final ArrayList<Capacitor> capacitors;
    private final ArrayList<Wire> wires;
    private final ArrayList<ICircuit.CircuitChangeListener> listeners;
    private Property<Double> currentAmplitudeProperty;
    private double previousTotalCharge;

    protected AbstractCircuit(CircuitConfig circuitConfig, String string, int n, CreateCapacitors createCapacitors, CreateWires createWires) {
        this.displayName = string;
        this.clock = circuitConfig.clock;
        this.listeners = new ArrayList();
        this.currentAmplitudeProperty = new Property<Double>(0.0);
        this.previousTotalCharge = -1.0;
        this.battery = new Battery(circuitConfig.batteryLocation, CLConstants.BATTERY_VOLTAGE_RANGE.getDefault(), circuitConfig.mvt);
        this.capacitors = createCapacitors.apply(circuitConfig, n);
        assert (this.capacitors.size() >= 1);
        this.wires = createWires.apply(circuitConfig, this.battery, this.capacitors);
        assert (this.wires.size() >= 2);
        this.clockListener = new ClockAdapter(){

            public void simulationTimeChanged(ClockEvent clockEvent) {
                AbstractCircuit.this.updateCurrentAmplitude();
            }
        };
        this.clock.addClockListener(this.clockListener);
        Capacitor.CapacitorChangeListener capacitorChangeListener = new Capacitor.CapacitorChangeListener(){

            public void capacitorChanged() {
                AbstractCircuit.this.updatePlateVoltages();
                AbstractCircuit.this.fireCircuitChanged();
            }
        };
        for (Capacitor capacitor : this.capacitors) {
            capacitor.addCapacitorChangeListener(capacitorChangeListener);
        }
        this.battery.addVoltageObserver(new SimpleObserver(){

            public void update() {
                AbstractCircuit.this.updatePlateVoltages();
            }
        }, false);
    }

    protected abstract void updatePlateVoltages();

    @Override
    public void reset() {
        this.battery.reset();
        for (Capacitor capacitor : this.capacitors) {
            capacitor.reset();
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public Battery getBattery() {
        return this.battery;
    }

    @Override
    public boolean isBatteryConnected() {
        return true;
    }

    @Override
    public ArrayList<Capacitor> getCapacitors() {
        return new ArrayList<Capacitor>(this.capacitors);
    }

    @Override
    public ArrayList<Wire> getWires() {
        return new ArrayList<Wire>(this.wires);
    }

    public Wire getTopWire() {
        return this.wires.get(0);
    }

    public Wire getBottomWire() {
        return this.wires.get(this.wires.size() - 1);
    }

    @Override
    public double getTotalCharge() {
        return this.getTotalVoltage() * this.getTotalCapacitance();
    }

    public double getTotalVoltage() {
        return this.battery.getVoltage();
    }

    @Override
    public double getVoltageBetween(Shape shape, Shape shape2) {
        return this.getVoltageAt(shape) - this.getVoltageAt(shape2);
    }

    @Override
    public double getStoredEnergy() {
        double d = this.getTotalCapacitance();
        double d2 = this.getTotalVoltage();
        return 0.5 * d * d2 * d2;
    }

    @Override
    public double getEffectiveEFieldAt(Point3D point3D) {
        double d = 0.0;
        for (Capacitor capacitor : this.getCapacitors()) {
            if (!capacitor.isBetweenPlates(point3D)) continue;
            d = capacitor.getEffectiveEField();
            break;
        }
        return d;
    }

    @Override
    public double getPlatesDielectricEFieldAt(Point3D point3D) {
        double d = 0.0;
        for (Capacitor capacitor : this.getCapacitors()) {
            if (capacitor.isInsideDielectricBetweenPlates(point3D)) {
                d = capacitor.getPlatesDielectricEField();
                break;
            }
            if (!capacitor.isInsideAirBetweenPlates(point3D)) continue;
            d = capacitor.getPlatesAirEField();
            break;
        }
        return d;
    }

    @Override
    public double getDielectricEFieldAt(Point3D point3D) {
        double d = 0.0;
        for (Capacitor capacitor : this.getCapacitors()) {
            if (capacitor.isInsideDielectricBetweenPlates(point3D)) {
                d = capacitor.getDielectricEField();
                break;
            }
            if (!capacitor.isInsideAirBetweenPlates(point3D)) continue;
            d = capacitor.getAirEField();
            break;
        }
        return d;
    }

    @Override
    public double getCurrentAmplitude() {
        return this.currentAmplitudeProperty.get();
    }

    private void updateCurrentAmplitude() {
        double d = this.getTotalCharge();
        if (this.previousTotalCharge != -1.0) {
            double d2 = d - this.previousTotalCharge;
            double d3 = this.clock.getSimulationTimeChange();
            double d4 = d2 / d3;
            this.currentAmplitudeProperty.set(d4);
        }
        this.previousTotalCharge = d;
    }

    @Override
    public void addCurrentAmplitudeObserver(SimpleObserver simpleObserver) {
        this.currentAmplitudeProperty.addObserver(simpleObserver);
    }

    @Override
    public void addCircuitChangeListener(ICircuit.CircuitChangeListener circuitChangeListener) {
        this.listeners.add(circuitChangeListener);
    }

    @Override
    public void removeCircuitChangeListener(ICircuit.CircuitChangeListener circuitChangeListener) {
        this.listeners.remove(circuitChangeListener);
    }

    protected void fireCircuitChanged() {
        for (ICircuit.CircuitChangeListener circuitChangeListener : new ArrayList<ICircuit.CircuitChangeListener>(this.listeners)) {
            circuitChangeListener.circuitChanged();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CreateCapacitors {
        public ArrayList<Capacitor> apply(CircuitConfig var1, Integer var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CreateWires {
        public ArrayList<Wire> apply(CircuitConfig var1, Battery var2, ArrayList<Capacitor> var3);
    }
}

