/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.model;

import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.DielectricMaterial;
import edu.colorado.phet.capacitorlab.shapes.CapacitorShapeCreator;
import edu.colorado.phet.common.phetcommon.math.Dimension3D;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.ShapeUtils;
import java.awt.Shape;
import java.util.ArrayList;

public class Capacitor {
    private final CLModelViewTransform3D mvt;
    private final CapacitorShapeCreator shapeCreator;
    private final SimpleObserver propertiesObserver;
    private final SimpleObserver dielectricConstantObserver;
    private final ArrayList<CapacitorChangeListener> listeners = new ArrayList();
    private final Point3D location;
    private final Property<Dimension3D> plateSizeProperty;
    private final Property<Double> plateSeparationProperty;
    private final Property<DielectricMaterial> dielectricMaterialProperty;
    private final Property<Double> dielectricOffsetProperty;
    private final Property<Double> platesVoltageProperty;

    public Capacitor(Point3D point3D, double d, double d2, DielectricMaterial dielectricMaterial, double d3, CLModelViewTransform3D cLModelViewTransform3D) {
        this.mvt = cLModelViewTransform3D;
        this.shapeCreator = new CapacitorShapeCreator(this, cLModelViewTransform3D);
        this.location = new Point3D.Double(point3D);
        this.plateSizeProperty = new Property<Dimension3D>(new Dimension3D(d, 5.0E-4, d));
        this.plateSeparationProperty = new Property<Double>(d2);
        this.dielectricMaterialProperty = new Property<DielectricMaterial>(dielectricMaterial);
        this.dielectricOffsetProperty = new Property<Double>(d3);
        this.platesVoltageProperty = new Property<Double>(0.0);
        this.propertiesObserver = new SimpleObserver(){

            public void update() {
                Capacitor.this.fireCapacitorChanged();
            }
        };
        this.plateSizeProperty.addObserver(this.propertiesObserver);
        this.plateSeparationProperty.addObserver(this.propertiesObserver);
        this.dielectricOffsetProperty.addObserver(this.propertiesObserver);
        this.dielectricMaterialProperty.addObserver(this.propertiesObserver);
        this.dielectricMaterialProperty.get().addDielectricConstantObserver(this.propertiesObserver);
        this.platesVoltageProperty.addObserver(this.propertiesObserver);
        this.dielectricConstantObserver = new SimpleObserver(){

            public void update() {
                Capacitor.this.fireCapacitorChanged();
            }
        };
        this.dielectricMaterialProperty.addObserver(new ChangeObserver<DielectricMaterial>(){

            @Override
            public void update(DielectricMaterial dielectricMaterial, DielectricMaterial dielectricMaterial2) {
                dielectricMaterial2.removeDielectricConstantObserver(Capacitor.this.dielectricConstantObserver);
                dielectricMaterial.addDielectricConstantObserver(Capacitor.this.dielectricConstantObserver);
            }
        });
        this.dielectricMaterialProperty.get().addDielectricConstantObserver(this.dielectricConstantObserver);
    }

    public void reset() {
        this.plateSizeProperty.reset();
        this.plateSeparationProperty.reset();
        this.dielectricMaterialProperty.reset();
        this.dielectricOffsetProperty.reset();
        this.platesVoltageProperty.reset();
    }

    public Point3D getLocation() {
        return new Point3D.Double(this.location);
    }

    public double getX() {
        return this.location.getX();
    }

    public double getY() {
        return this.location.getY();
    }

    public double getZ() {
        return this.location.getZ();
    }

    public Dimension3D getPlateSize() {
        return new Dimension3D(this.plateSizeProperty.get());
    }

    public void setPlateWidth(double d) {
        if (!(d > 0.0)) {
            throw new IllegalArgumentException("plateWidth must be > 0: " + d);
        }
        this.plateSizeProperty.set(new Dimension3D(d, this.getPlateHeight(), d));
    }

    public double getPlateWidth() {
        return this.plateSizeProperty.get().getWidth();
    }

    public double getPlateHeight() {
        return this.plateSizeProperty.get().getHeight();
    }

    public double getPlateDepth() {
        return this.plateSizeProperty.get().getDepth();
    }

    public double getPlateArea() {
        return this.getPlateWidth() * this.getPlateDepth();
    }

    public void addPlateSizeObserver(SimpleObserver simpleObserver, boolean bl) {
        this.plateSizeProperty.addObserver(simpleObserver, bl);
    }

    public void addPlateSizeObserver(SimpleObserver simpleObserver) {
        this.addPlateSizeObserver(simpleObserver, true);
    }

    public void setPlateSeparation(double d) {
        if (!(d > 0.0)) {
            throw new IllegalArgumentException("plateSeparation must be > 0: " + d);
        }
        this.plateSeparationProperty.set(d);
    }

    public double getPlateSeparation() {
        return this.plateSeparationProperty.get();
    }

    public void addPlateSeparationObserver(SimpleObserver simpleObserver) {
        this.plateSeparationProperty.addObserver(simpleObserver);
    }

    public Point3D getTopPlateCenter() {
        return new Point3D.Double(this.getX(), this.getY() - this.getPlateSeparation() / 2.0 - this.getPlateHeight(), this.getZ());
    }

    public Point3D getBottomPlateCenter() {
        return new Point3D.Double(this.getX(), this.getY() + this.getPlateSeparation() / 2.0 + this.getPlateHeight(), this.getZ());
    }

    public void setDielectricMaterial(DielectricMaterial dielectricMaterial) {
        if (dielectricMaterial == null) {
            throw new IllegalArgumentException("dielectricMaterial must be non-null");
        }
        this.dielectricMaterialProperty.get().removeDielectricConstantObserver(this.propertiesObserver);
        this.dielectricMaterialProperty.set(dielectricMaterial);
        this.dielectricMaterialProperty.get().addDielectricConstantObserver(this.propertiesObserver);
    }

    public DielectricMaterial getDielectricMaterial() {
        return this.dielectricMaterialProperty.get();
    }

    public void addDielectricMaterialObserver(SimpleObserver simpleObserver) {
        this.dielectricMaterialProperty.addObserver(simpleObserver);
    }

    public double getDielectricConstant() {
        return this.getDielectricMaterial().getDielectricConstant();
    }

    public Dimension3D getDielectricSize() {
        return new Dimension3D(this.getDielectricWidth(), this.getDielectricHeight(), this.getDielectricDepth());
    }

    public double getDielectricWidth() {
        return this.getPlateWidth();
    }

    public double getDielectricHeight() {
        return this.getPlateSeparation();
    }

    public double getDielectricDepth() {
        return this.getPlateDepth();
    }

    public void setDielectricOffset(double d) {
        if (!(d >= 0.0)) {
            throw new IllegalArgumentException("dielectricOffset must be >= 0: " + d);
        }
        this.dielectricOffsetProperty.set(d);
    }

    public double getDielectricOffset() {
        return this.dielectricOffsetProperty.get();
    }

    public void addDielectricOffsetObserver(SimpleObserver simpleObserver) {
        this.dielectricOffsetProperty.addObserver(simpleObserver);
    }

    public double getAirContactArea() {
        return this.getPlateArea() - this.getDielectricContactArea();
    }

    public double getDielectricContactArea() {
        double d = Math.abs(this.getDielectricOffset());
        double d2 = (this.getPlateWidth() - d) * this.getPlateDepth();
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        return d2;
    }

    public void setTotalCapacitance(double d) {
        this.setPlateSeparation(Capacitor.getPlateSeparation(this.getDielectricConstant(), this.getPlateWidth(), d));
    }

    public static double getPlateSeparation(double d, double d2, double d3) {
        return d * 8.854E-12 * d2 * d2 / d3;
    }

    public double getTotalCapacitance() {
        return this.getAirCapacitance() + this.getDielectricCapacitance();
    }

    public double getAirCapacitance() {
        return Capacitor.getCapacitance(1.0, this.getAirContactArea(), this.getPlateSeparation());
    }

    public double getDielectricCapacitance() {
        return Capacitor.getCapacitance(this.getDielectricConstant(), this.getDielectricContactArea(), this.getPlateSeparation());
    }

    private static double getCapacitance(double d, double d2, double d3) {
        return d * 8.854E-12 * d2 / d3;
    }

    public CapacitorShapeCreator getShapeCreator() {
        return this.shapeCreator;
    }

    public boolean intersectsTopPlate(Shape shape) {
        return ShapeUtils.intersects(shape, this.shapeCreator.createTopPlateShapeOccluded());
    }

    public boolean intersectsBottomPlate(Shape shape) {
        return ShapeUtils.intersects(shape, this.shapeCreator.createBottomPlateShapeOccluded());
    }

    public boolean isBetweenPlates(Point3D point3D) {
        return this.isInsideDielectricBetweenPlates(point3D) || this.isInsideAirBetweenPlates(point3D);
    }

    public boolean isInsideDielectricBetweenPlates(Point3D point3D) {
        return this.shapeCreator.createDielectricBetweenPlatesShapeOccluded().contains(this.mvt.modelToView(point3D));
    }

    public boolean isInsideAirBetweenPlates(Point3D point3D) {
        return this.shapeCreator.createAirBetweenPlatesShapeOccluded().contains(this.mvt.modelToView(point3D));
    }

    public void setPlatesVoltage(double d) {
        this.platesVoltageProperty.set(d);
    }

    public double getPlatesVoltage() {
        return this.platesVoltageProperty.get();
    }

    public double getAirPlateCharge() {
        return this.getAirCapacitance() * this.getPlatesVoltage();
    }

    public double getDielectricPlateCharge() {
        return this.getDielectricCapacitance() * this.getPlatesVoltage();
    }

    public double getTotalPlateCharge() {
        return this.getDielectricPlateCharge() + this.getAirPlateCharge();
    }

    public double getExcessAirPlateCharge() {
        return Capacitor.getExcessPlateCharge(1.0, this.getAirCapacitance(), this.getPlatesVoltage());
    }

    public double getExcessDielectricPlateCharge() {
        return Capacitor.getExcessPlateCharge(this.getDielectricConstant(), this.getDielectricCapacitance(), this.getPlatesVoltage());
    }

    private static double getExcessPlateCharge(double d, double d2, double d3) {
        if (!(d > 0.0)) {
            throw new IllegalArgumentException("model requires epsilon_r > 0 : " + d);
        }
        return (d - 1.0) / d * d2 * d3;
    }

    public double getEffectiveEField() {
        return this.getPlatesVoltage() / this.getPlateSeparation();
    }

    public double getPlatesAirEField() {
        return Capacitor.getPlatesEField(1.0, this.getPlatesVoltage(), this.getPlateSeparation());
    }

    public double getPlatesDielectricEField() {
        return Capacitor.getPlatesEField(this.getDielectricConstant(), this.getPlatesVoltage(), this.getPlateSeparation());
    }

    private static double getPlatesEField(double d, double d2, double d3) {
        if (!(d3 > 0.0)) {
            throw new IllegalArgumentException("model requires d (plate separation) > 0 : " + d3);
        }
        return d * d2 / d3;
    }

    public double getAirEField() {
        return this.getPlatesAirEField() - this.getEffectiveEField();
    }

    public double getDielectricEField() {
        return this.getPlatesDielectricEField() - this.getEffectiveEField();
    }

    public void addCapacitorChangeListener(CapacitorChangeListener capacitorChangeListener) {
        this.listeners.add(capacitorChangeListener);
    }

    public void fireCapacitorChanged() {
        for (CapacitorChangeListener capacitorChangeListener : new ArrayList<CapacitorChangeListener>(this.listeners)) {
            capacitorChangeListener.capacitorChanged();
        }
    }

    public static interface CapacitorChangeListener {
        public void capacitorChanged();
    }
}

