/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.drag;

import edu.colorado.phet.capacitorlab.CLStrings;
import edu.colorado.phet.capacitorlab.drag.DragHandleArrowNode;
import edu.colorado.phet.capacitorlab.drag.DragHandleLineNode;
import edu.colorado.phet.capacitorlab.drag.DragHandleValueNode;
import edu.colorado.phet.capacitorlab.drag.PlateSeparationDragHandler;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.util.UnitsUtils;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import java.awt.geom.Point2D;

public class PlateSeparationDragHandleNode
extends PhetPNode {
    private static final Point2D ARROW_START_LOCATION = new Point2D.Double(0.0, 0.0);
    private static final Point2D ARROW_END_LOCATION = new Point2D.Double(0.0, -35.0);
    private static final Point2D LINE_START_LOCATION = new Point2D.Double(0.0, 0.0);
    private static final Point2D LINE_END_LOCATION = new Point2D.Double(0.0, -60.0);
    private final Capacitor capacitor;
    private final CLModelViewTransform3D mvt;
    private final DragHandleValueNode valueNode;

    public PlateSeparationDragHandleNode(Capacitor capacitor, CLModelViewTransform3D cLModelViewTransform3D, DoubleRange doubleRange) {
        this.capacitor = capacitor;
        this.mvt = cLModelViewTransform3D;
        DragHandleArrowNode dragHandleArrowNode = new DragHandleArrowNode(ARROW_START_LOCATION, ARROW_END_LOCATION);
        dragHandleArrowNode.addInputEventListener(new PlateSeparationDragHandler(this, capacitor, cLModelViewTransform3D, doubleRange));
        DragHandleLineNode dragHandleLineNode = new DragHandleLineNode(LINE_START_LOCATION, LINE_END_LOCATION);
        double d = UnitsUtils.metersToMillimeters(capacitor.getPlateSeparation());
        this.valueNode = new DragHandleValueNode(CLStrings.PATTERN_VALUE_UNITS, CLStrings.SEPARATION, d, CLStrings.MILLIMETERS);
        this.addChild(dragHandleLineNode);
        this.addChild(dragHandleArrowNode);
        this.addChild(this.valueNode);
        double d2 = 0.0;
        double d3 = 0.0;
        dragHandleLineNode.setOffset(d2, d3);
        d2 = 0.0;
        d3 = dragHandleLineNode.getFullBoundsReference().getMinY() - 2.0;
        dragHandleArrowNode.setOffset(d2, d3);
        d2 = dragHandleArrowNode.getFullBoundsReference().getMaxX() - this.valueNode.getFullBoundsReference().getWidth();
        d3 = dragHandleArrowNode.getFullBoundsReference().getMinY() - this.valueNode.getFullBoundsReference().getHeight();
        this.valueNode.setOffset(d2, d3);
        capacitor.addPlateSeparationObserver(new SimpleObserver(){

            public void update() {
                PlateSeparationDragHandleNode.this.updateValueDisplay();
                PlateSeparationDragHandleNode.this.updateOffset();
            }
        });
        capacitor.addPlateSizeObserver(new SimpleObserver(){

            public void update() {
                PlateSeparationDragHandleNode.this.updateOffset();
            }
        });
    }

    private void updateValueDisplay() {
        double d = UnitsUtils.metersToMillimeters(this.capacitor.getPlateSeparation());
        this.valueNode.setValue(d);
    }

    private void updateOffset() {
        double d = this.capacitor.getX() - 0.3 * this.capacitor.getPlateWidth();
        double d2 = this.capacitor.getY() - this.capacitor.getPlateSeparation() / 2.0 - this.capacitor.getPlateHeight();
        double d3 = 0.0;
        Point2D point2D = this.mvt.modelToView(d, d2, d3);
        this.setOffset(point2D);
    }
}

