/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.drag;

import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;

class PlateAreaDragHandler
extends PDragSequenceEventHandler {
    private final PNode dragNode;
    private final Capacitor capacitor;
    private final CLModelViewTransform3D mvt;
    private final DoubleRange valueRange;
    private double clickXOffset;

    public PlateAreaDragHandler(PNode pNode, Capacitor capacitor, CLModelViewTransform3D cLModelViewTransform3D, DoubleRange doubleRange) {
        this.dragNode = pNode;
        this.capacitor = capacitor;
        this.mvt = cLModelViewTransform3D;
        this.valueRange = new DoubleRange(doubleRange);
    }

    protected void startDrag(PInputEvent pInputEvent) {
        super.startDrag(pInputEvent);
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.dragNode.getParent());
        Point2D point2D2 = this.mvt.modelToViewDelta(-this.capacitor.getPlateWidth() / 2.0, 0.0, -this.capacitor.getPlateWidth() / 2.0);
        this.clickXOffset = point2D.getX() - point2D2.getX();
    }

    protected void drag(PInputEvent pInputEvent) {
        super.drag(pInputEvent);
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.dragNode.getParent());
        double d = this.getPlateWidth(point2D);
        this.capacitor.setPlateWidth(d);
    }

    private double getPlateWidth(Point2D point2D) {
        double d = this.getModelX(point2D, 0.0);
        double d2 = this.getModelX(point2D, 1.0);
        Function.LinearFunction linearFunction = new Function.LinearFunction(0.0, 1.0, d, d2);
        return MathUtil.clamp(linearFunction.createInverse().evaluate(0.0), this.valueRange);
    }

    private double getModelX(Point2D point2D, double d) {
        Point2D point2D2 = this.mvt.modelToView(-d / 2.0, 0.0, -d / 2.0);
        return point2D.getX() - point2D2.getX() - this.clickXOffset;
    }
}

