/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.developer;

import edu.colorado.phet.capacitorlab.CLPaints;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.model.circuit.ICircuit;
import edu.colorado.phet.capacitorlab.shapes.CapacitorShapeCreator;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;

public class EFieldShapesDebugNode
extends PComposite {
    private static final Stroke STROKE = new BasicStroke(2.0f);
    private static final Color STROKE_COLOR = CLPaints.EFIELD_DEBUG_SHAPES;

    public EFieldShapesDebugNode(ICircuit iCircuit) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        for (Capacitor capacitor : iCircuit.getCapacitors()) {
            final CapacitorShapeCreator capacitorShapeCreator = capacitor.getShapeCreator();
            final PhetPPath phetPPath = new PhetPPath(capacitorShapeCreator.createDielectricBetweenPlatesShapeOccluded(), STROKE, (Paint)STROKE_COLOR);
            this.addChild(phetPPath);
            final PhetPPath phetPPath2 = new PhetPPath(capacitorShapeCreator.createAirBetweenPlatesShapeOccluded(), STROKE, (Paint)STROKE_COLOR);
            this.addChild(phetPPath2);
            SimpleObserver simpleObserver = new SimpleObserver(){

                public void update() {
                    phetPPath.setPathTo(capacitorShapeCreator.createDielectricBetweenPlatesShapeOccluded());
                    phetPPath2.setPathTo(capacitorShapeCreator.createAirBetweenPlatesShapeOccluded());
                }
            };
            capacitor.addPlateSizeObserver(simpleObserver);
            capacitor.addPlateSeparationObserver(simpleObserver);
            capacitor.addDielectricOffsetObserver(simpleObserver);
        }
    }
}

