/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.control;

import edu.colorado.phet.capacitorlab.CLImages;
import edu.colorado.phet.capacitorlab.CLStrings;
import edu.colorado.phet.capacitorlab.model.Battery;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.event.HighlightHandler;
import edu.colorado.phet.common.piccolophet.event.SliderThumbDragHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.text.DecimalFormat;
import java.text.MessageFormat;

public class VoltageSliderNode
extends PhetPNode {
    private static final Color TRACK_COLOR = Color.BLACK;
    private static final Stroke TRACK_STROKE = new BasicStroke(2.0f);
    private static final Color TICK_MARK_COLOR = TRACK_COLOR;
    private static final Stroke TICK_MARK_STROKE = TRACK_STROKE;
    private static final Color TICK_LABEL_COLOR = TRACK_COLOR;
    private static final DecimalFormat TICK_LABEL_NONZERO_FORMAT = new DecimalFormat("0.0");
    private static final DecimalFormat TICK_LABEL_ZERO_FORMAT = new DecimalFormat("0");
    private static final Font TICK_LABEL_FONT = new PhetFont(14);
    private final TrackNode trackNode;
    private final KnobNode knobNode;

    public VoltageSliderNode(final Battery battery, final DoubleRange doubleRange, double d) {
        this.trackNode = new TrackNode(d);
        this.addChild(this.trackNode);
        assert (doubleRange.getMax() > 0.0 && doubleRange.getMin() < 0.0);
        TickNode tickNode = new TickNode(13.0, doubleRange.getMax());
        this.addChild(tickNode);
        TickNode tickNode2 = new TickNode(13.0, 0.0);
        this.addChild(tickNode2);
        TickNode tickNode3 = new TickNode(13.0, doubleRange.getMin());
        this.addChild(tickNode3);
        this.knobNode = new KnobNode(this, this.trackNode, doubleRange, battery);
        this.addChild(this.knobNode);
        double d2 = 0.0;
        double d3 = 0.0;
        this.trackNode.setOffset(d2, d3);
        tickNode.setOffset(d2, d3);
        d3 = this.trackNode.getFullBoundsReference().getHeight() / 2.0;
        tickNode2.setOffset(d2, d3);
        d3 = this.trackNode.getFullBoundsReference().getHeight();
        tickNode3.setOffset(d2, d3);
        d3 = 0.0;
        this.knobNode.setOffset(d2, d3);
        battery.addVoltageObserver(new SimpleObserver(){

            public void update() {
                double d = battery.getVoltage();
                double d2 = VoltageSliderNode.this.knobNode.getXOffset();
                double d3 = VoltageSliderNode.this.trackNode.getFullBoundsReference().getHeight() * ((doubleRange.getMax() - d) / doubleRange.getLength());
                VoltageSliderNode.this.knobNode.setOffset(d2, d3);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KnobDragHandler
    extends SliderThumbDragHandler {
        private final double snapThreshold;

        public KnobDragHandler(PNode pNode, PNode pNode2, PNode pNode3, DoubleRange doubleRange, double d, VoidFunction1<Double> voidFunction1) {
            super(SliderThumbDragHandler.Orientation.VERTICAL, pNode, pNode2, pNode3, doubleRange, voidFunction1);
            this.snapThreshold = d;
        }

        @Override
        protected double adjustValue(double d) {
            return Math.abs(d) <= this.snapThreshold ? 0.0 : d;
        }
    }

    private static class KnobNode
    extends PNode {
        public KnobNode(PNode pNode, PNode pNode2, DoubleRange doubleRange, final Battery battery) {
            PImage pImage = new PImage(CLImages.SLIDER_KNOB);
            this.addChild(pImage);
            double d = -(pImage.getFullBoundsReference().getWidth() / 2.0);
            double d2 = -(pImage.getFullBoundsReference().getHeight() / 2.0);
            pImage.setOffset(d, d2);
            this.addInputEventListener(new CursorHandler());
            this.addInputEventListener(new HighlightHandler.ImageHighlightHandler(pImage, CLImages.SLIDER_KNOB, CLImages.SLIDER_KNOB_HIGHLIGHT));
            this.addInputEventListener(new KnobDragHandler(pNode, pNode2, (PNode)this, doubleRange, 0.1, new VoidFunction1<Double>(){

                @Override
                public void apply(Double d) {
                    battery.setVoltage(d);
                }
            }));
        }
    }

    private static class TickLabelNode
    extends PText {
        public TickLabelNode(double d) {
            this.setFont(TICK_LABEL_FONT);
            this.setTextPaint(TICK_LABEL_COLOR);
            DecimalFormat decimalFormat = d == 0.0 ? TICK_LABEL_ZERO_FORMAT : TICK_LABEL_NONZERO_FORMAT;
            this.setText(MessageFormat.format(CLStrings.PATTERN_VALUE_UNITS, decimalFormat.format(d), CLStrings.VOLTS));
        }
    }

    private static class TickMarkNode
    extends PPath {
        public TickMarkNode(double d) {
            super(new Line2D.Double(0.0, 0.0, d, 0.0));
            this.setStroke(TICK_MARK_STROKE);
            this.setStrokePaint(TICK_MARK_COLOR);
        }
    }

    private static class TickNode
    extends PComposite {
        public TickNode(double d, double d2) {
            TickMarkNode tickMarkNode = new TickMarkNode(d);
            this.addChild(tickMarkNode);
            TickLabelNode tickLabelNode = new TickLabelNode(d2);
            this.addChild(tickLabelNode);
            double d3 = 0.0;
            double d4 = 0.0;
            tickMarkNode.setOffset(d3, d4);
            d3 = tickMarkNode.getFullBoundsReference().getWidth() + 5.0;
            d4 = (tickMarkNode.getFullBoundsReference().getHeight() - tickLabelNode.getFullBoundsReference().getHeight()) / 2.0;
            tickLabelNode.setOffset(d3, d4);
        }
    }

    private static class TrackNode
    extends PPath {
        public TrackNode(double d) {
            super(new Line2D.Double(0.0, 0.0, 0.0, d));
            this.setStroke(TRACK_STROKE);
            this.setStrokePaint(TRACK_COLOR);
        }
    }
}

