/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.control;

import edu.colorado.phet.capacitorlab.CLStrings;
import edu.colorado.phet.capacitorlab.model.circuit.ICircuit;
import edu.colorado.phet.capacitorlab.model.circuit.SingleCircuit;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.TextButtonNode;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class BatteryConnectionButtonNode
extends TextButtonNode {
    public BatteryConnectionButtonNode(final SingleCircuit singleCircuit) {
        super(BatteryConnectionButtonNode.getText(singleCircuit.isBatteryConnected()));
        this.setFont(new PhetFont(20));
        this.setForeground(Color.BLACK);
        this.setBackground(Color.WHITE);
        this.addInputEventListener(new CursorHandler());
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                singleCircuit.setBatteryConnected(!singleCircuit.isBatteryConnected());
            }
        });
        singleCircuit.addCircuitChangeListener(new ICircuit.CircuitChangeListener(){

            public void circuitChanged() {
                BatteryConnectionButtonNode.this.setText(BatteryConnectionButtonNode.getText(singleCircuit.isBatteryConnected()));
            }
        });
    }

    private static String getText(boolean bl) {
        return bl ? CLStrings.DISCONNECT_BATTERY : CLStrings.CONNECT_BATTERY;
    }
}

